require( "scripts/style.lua" );


TitleFont = {
  standardFont,
  32,
  BorderColor
};

InfoFont = {
  standardFont,
  16,
  BorderColor
};

YahooFont = {
  standardFont,
  12,
  BorderColor
};

HeaderFont = {
  standardFont,
  20,
  BorderColor
};

ChangeFont = {
  standardFont,
  12,
  BorderColor
};
NameFont = {
  standardFont,
  16,
  BorderColor
};

ConnectingFont = {
  standardFont,
  36,
  BorderColor
};

RememberFont = {
  standardFont,
  12,
  BorderColor
};

PrivacyFont = {
  standardFont,
  10,
  WhiteColor
};



kTextX = 30;
kTextW = kMax - 30;
kTextH = 60;




local gInAnonymousMode = false;
local gCreatingNewUser = GetSessionSetting('creatingnewuser') == 'true' or GetCurrentUser() < 0;


function SwitchAnonModes(anon)
	SetupLoginUser();
	EnableWindow('login_nothanks', InAnonymousArea() == true and (not anon) and GetStrSetting('pfuser', '') == '');
	if (InAnonymousArea()) then
		EnableWindow('login_required', false);
		if (GetSessionSetting('launchlogin', 'false')=='true') then
			EnableWindow('login_youhaveloggedout', false);
			EnableWindow('login_optional', not (anon));
		else
			EnableWindow('login_youhaveloggedout', not (anon) and GetNumUsers() > 0);
			EnableWindow('login_optional', false);
		end
	else
		EnableWindow('login_required', true);
		EnableWindow('login_youhaveloggedout', false);
		EnableWindow('login_optional', false);
	end
	EnableWindow('login_gamename', anon and gCreatingNewUser);
	EnableWindow('login_pass', not anon);
	EnableWindow('login_passwordforgot', not anon);
	EnableWindow('loginpasstextimg', not anon);
	EnableWindow('login_remember', not anon);
	EnableWindow('login_fulllogin', anon);
	if (anon) then
		SetTextEditLength("useredit", kMaxUserNameLength);
		SetTextEditIllegals("useredit", kIllegalNameChars);
	else
		SetTextEditLength("useredit", kMaxPFUsernameLength);
		SetTextEditIllegals("useredit", kIllegalLoginChars);
	end
	gInAnonymousMode = anon;
	
end

function SetupLoginUser()
	if (GetStrSetting('pfuser', '') ~= '') then
		EnableWindow("usereditlocked", true);
		EnableWindow("loginusertextimg", false);
		SetWindowText("usereditlocked", GetStrSetting('pfuser', ''));
		SetWindowText("useredit", GetStrSetting('pfuser', ''));
		SetLabel("passedit", GetStrSetting('pfpass', ''));
		SetFocus( "passedit" );
	else
		if (gCreatingNewUser or not gInAnonymousMode) then
			EnableWindow("usereditlocked", false);
			EnableWindow("loginusertextimg", true);
			SetWindowText("usereditlocked", "");
			SetWindowText("useredit", "");
			SetFocus( "useredit" );
		else
			EnableWindow("usereditlocked", true);
			EnableWindow("loginusertextimg", false);
			SetWindowText("usereditlocked", GetCurrentUserName());
			SetWindowText("useredit", GetCurrentUserName());
			SetFocus( "" );
		end
		SetLabel("passedit", GetStrSetting('pfpass', ''));
		
	end
	
end

function CreateUniqueUserName(username)
	name = username;
	if (IsPlayFirstNameInUse(name)) then
		number = 2;
		while (IsPlayFirstNameInUse(name)) do
			name = username .. " (" .. tostring(number) .. ")";
			number = number + 1;
		end
	end	
	return name;
end

backgroundimage = 'backgrounds/login';
loginx = 110;
loginy = 300;
cancelx = 240;
cancely = 300;

if (GetSessionSetting('initiallogin') == 'true') then
	backgroundimage = 'menu/mainmenu';
end

local showCancel = GetSessionSetting('initiallogin') ~= 'true' or gCreatingNewUser;


function AddBuildSpecificText()
	if (BuildHasRefCode("yahoo")) then
		return Group{
			Text
			{
				label = 'login_yahoo',
				name = 'login_yahoo',
				x = 0, w = kMax,
				y = 390, h = 60,
				flags = kHAlignCenter + kVAlignCenter,
				font = YahooFont
			};
		};
	else
		return Group{};
	end
end

headerTextX = 70;
headerTextW = kMax - 70;
headerTextY = 50;
headerTextH = 100;
MakeDialog
{
	Bitmap
	{ 
		image=backgroundimage,
		x=kCenter,
		y=kCenter,		
		
		PopThroughBitmap
		{ 
			image='backgrounds/login',
			x=kCenter,
			y=kCenter,	
			fit = false,
			
			Text
			{
				label = 'login_title',
				x = kTextX, w = kTextW,
				y = 15, h = 50,
				flags = kHAlignCenter + kVAlignTop,
				font = TitleFont
			};
			
			Text
			{
				label = 'login_required',
				name = 'login_required',
				x = headerTextX, w = headerTextW,
				y = headerTextY, h = headerTextH,
				flags = kHAlignLeft + kVAlignCenter,
				font = HeaderFont,
				padding = 0
			};
			
			Text
			{
				label = 'login_optional',
				name = 'login_optional',
				x = headerTextX, w = headerTextW,
				y = headerTextY, h = headerTextH,
				flags = kHAlignLeft + kVAlignCenter,
				font = HeaderFont,
				padding = 0
			};
			
			Text
			{
				label = 'login_youhaveloggedout',
				name = 'login_youhaveloggedout',
				x = headerTextX, w = headerTextW,
				y = headerTextY, h = headerTextH,
				flags = kHAlignLeft + kVAlignCenter,
				font = HeaderFont,
				padding = 0
			};
			
			Text
			{
				label = 'login_gamename',
				name = 'login_gamename',
				x = headerTextX, w = headerTextW,
				y = headerTextY, h = headerTextH,
				flags = kHAlignLeft + kVAlignCenter,
				font = HeaderFont,
				padding = 0
			};
			
			Text
			{
				label = 'login_user',
				name = 'login_user',
				x = 75, w = 100,
				y = 165, h = 30,
				flags = kHAlignRight + kVAlignCenter,
				font = HeaderFont
			};
			
			Text
			{
				label = 'login_pass',
				name = 'login_pass',
				x = 75, w = 100,
				y = 220, h = 30,
				flags = kHAlignRight + kVAlignCenter,
				font = HeaderFont
			};
			

			
			LinkText
			{
				label = 'login_nothanks',
				name = 'login_nothanks',
				x = 0, w = kMax,
				y = 270, h = 30,
				flags = kHAlignCenter + kVAlignCenter,
				font = InfoFont
			};
			
			LinkText
			{
				label = 'login_fulllogin',
				name = 'login_fulllogin',
				x = 0, w = kMax,
				y = 215, h = 30,
				flags = kHAlignCenter + kVAlignCenter,
				font = InfoFont
			};
			
			LinkText
			{
				label = 'login_create',
				name = 'login_create',
				x = 0, w = kMax,
				y = 350, h = 60,
				flags = kHAlignCenter + kVAlignCenter,
				font = InfoFont
			};
			
			LinkText
			{
				label = 'login_passwordforgot',
				name = 'login_passwordforgot',
				x=185, y=260,
				w = 280, h = 16,
				flags = kHAlignLeft + kVAlignTop,
				font = ChangeFont,
			};
			
			AddBuildSpecificText();
			
			
			Text
			{
				x=185,
				y=165,
				w = 280,
				h = 32,
				name = "usereditlocked",
				label = '',
				flags = kHAlignLeft + kVAlignCenter
			};
			
			Bitmap
			{
				image="backgrounds/shorttextfield",
				name = 'loginusertextimg',
				x=180,
				y=165,
				
				TextEdit
				{
					font = NameFont,
					name = "useredit",
					label = startname,
					x=5,y=6,w=kMax-5,h=kMax,
					length=kMaxPFUsernameLength,
					ignore = kIllegalLoginChars
					
				};
			};
			
			Bitmap
			{
				image="backgrounds/shorttextfield",
				name = 'loginpasstextimg',
				x=180,
				y=220,
				
				TextEdit
				{
					font = NameFont,
					name = "passedit",
					label = startname,
					x=5,y=6,w=kMax-5,h=kMax,
					length=20,
					password=true
					
				};
				
			};
						
			Button{
				graphics = CheckboxButtonGraphics,
				name="login_remember",
				type = kToggle,
				x=305,
				y=250,
				w=80,
				tx = 5,
				ty = 10,
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
				label = 'login_remember',
				font = RememberFont,
				flags = kHAlignRight + kVAlignTop,
				command =
					function()

					end
				
			};
			
			LinkText
			{
				label = 'privacybutton',
				font = PrivacyFont,
				x = 150,
				y = 445,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop
			};
			
			LinkText
			{
				label = 'tosbutton',
				font = PrivacyFont,
				x = 250,
				y = 445,
				w = kMax,
				h = kMax,
				flags = kHAlignLeft + kVAlignTop
			};
			
			LinkText
			{
				label = 'login_changeuser',
				name = 'changebutton',
				font = ChangeFont,
				x=185, y=200,
				w = 280, h = 16,
				flags = kHAlignLeft + kVAlignTop
			};
			
			SetStyle(DefaultStyle);
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'privacybutton',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../privacypolicy.html');
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'tosbutton',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../tos.html');
					end
				
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'createaccount',
				command = 
					function()
						LaunchHarnessPost('manager', 'content', '../createAccount.html');
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'forgotpassword',
				command = 
					function()
						LaunchWebBrowser("http://www.playfirst.com/forgotPassword.html ");
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'logingameonly',
				command = 
					function()
						SwitchAnonModes(true);
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'loginplayfirst',
				command = 
					function()
						SwitchAnonModes(false);
					end
			};
			
			Button
			{
				x = 0, y = 0, w = 0, h = 0,
				name = 'loginchangeuser',
				command = 
					function()
						DoModal("scripts/chooseplayer.lua");
						local requirePassword = InAnonymousArea();
						if (GetCurrentUser() >= 0 and GetStrSetting('pfuser', '') ~= '') then
							requirePassword = false;
						end
						if (IsLoggedIn(requirePassword)) then
							PostMessage( CreateNamedMessage( kPlayerLoggedIn, GetCurrentUserName() ) );
							PopModal("scripts/login.lua");
						else
							SwitchAnonModes(gInAnonymousMode);
						end
					end
			};
			
			SetStyle(SmallButtonStyle);
			Button
			{
				x = loginx,
				y = loginy,
				label = 'login',
				name = 'login',
				default = true,
				command =
					function()
						username = GetLabelSafe("useredit");
						password = GetLabelSafe("passedit");
						
						if (username == '') then
							DisplayDialog {
								'scripts/ok.lua', 
								body ='login_zerolength',
								title = ''
							};
						elseif (gInAnonymousMode == false and password == '') then
							DisplayDialog {
								'scripts/ok.lua', 
								body ='login_zeropasslength',
								title = ''
							};
						else
							loginSuccess = false;
							if (gInAnonymousMode == true) then
								if (IsAnonymousNameInUse(username)) then
									DisplayDialog {
										'scripts/ok.lua',
										body='login_failed',
										title=''
									}
								else
									loginSuccess = true;
								end								
							else
								EnableWindow('loginshield', true);								
								StartLogin(username, password, GetChecked("login_remember"));
								keepGoing = true;
								while (keepGoing) do
									Pause(50);
									loginState = GetLoginState();
									keepGoing = false;
									if (loginState == 1) then
										keepGoing = true;
									elseif (loginState ~= 2) then
										DisplayDialog {
											'scripts/ok.lua', 
											body ='login_failed',
											title = ''
										};
									else
										loginSuccess = true;
									end
								end
								if (loginSuccess) then
									StartLoginItemUpdate();
									while (LoginItemUpdateDone() == false) do
										Pause(50);
									end
								end
							end
							
							if (loginSuccess) then
								lockedStatus = IsEnabled("usereditlocked");
								unique = CreateUniqueUserName(username);
								currentUser = GetCurrentUser();
								
								if (currentUser >= 0 and not PFUserAccount(GetCurrentUser()) ) then
									ChangeCurrentUserName(unique);
								else
									if (not lockedStatus) then
										if (GetCurrentUser() < 0) then
											if (gInAnonymousMode == false) then
												username = GetLoginDisplayName();
												unique = CreateUniqueUserName(username);
											end
											CreateNewUser(unique);
										end	
									end
								end
								
								
								if (gInAnonymousMode == false) then
									SetStrSetting("pfuser", GetLoginDisplayName());
									if (GetChecked("login_remember")) then
										SetStrSetting("pfpass", GetLabel("passedit"));
									else
										SetStrSetting("pfpass", "");
									end
								end
								PostMessage( CreateNamedMessage( kPlayerLoggedIn, GetCurrentUserName() ) );
								PopModal('scripts/login.lua');
							end
							EnableWindow('loginshield', false);
						end
					end
			};	
			
			Button
			{
				x = cancelx,
				y = cancely,
				label = 'cancel',
				name = 'logincancel',
				command =
					function()
						PopModal('scripts/login.lua');
					end
			};
			
			Button
			{
				x = cancelx,
				y = cancely,
				label = 'quit',
				name = 'loginquit',
				command =
					function()
						result = DisplayDialog { 
							"scripts/yesno.lua", 
							body ="quitconfirm",
							title = "",
							popthrough = true
						};
						if (result=='yes') then
							PostMessage( CreateNamedMessage( kQuitNow, "Quit" ) );
						end
					end
			};
			
			SetStyle(DefaultStyle);
			
			MouseShield
			{	
				x = 0, y = 0,
				w = kMax, h = kMax,
				name = 'loginshield',
				Bitmap
				{
					
					x = 0, y = 0,
					image="backgrounds/login",
					
					Text
					{
						x = 50, w = kMax,
						y = 0, h = kMax,
						flags = kHAlignCenter + kVAlignCenter,
						font = ConnectingFont,
						label = 'login_connecting'
					};
				};
			};		
		},
	};
}


if (GetStrSetting('pfpass', '') ~= '') then
	SetChecked("login_remember", true);
end


SwitchAnonModes(gInAnonymousMode);

EnableWindow('loginshield', false);

if (not showCancel) then
	EnableWindow('logincancel', false);
else
	EnableWindow('loginquit', false);
end


if (GetSessionSetting('creatingnewuser') == 'true' or GetNumUsers() < 0) then
	EnableWindow('changebutton', false);
end
